<?php 
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
    'code' => 11,
    'msg' => 'Method not allowed', 
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

// Enhanced error logging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'debug.log');

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);
error_log("Raw Request: " . $shonubody);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    if (isset($shonupost['issueNumber']) && isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
        $issueNumber = mysqli_real_escape_string($conn, $shonupost['issueNumber']);
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
        
        error_log("Request Parameters: " . json_encode($shonupost));
        
        $shonustr = '{"issueNumber":"'.$issueNumber.'","language":'.$language.',"random":"'.$random.'"}';
        $shonusign = strtoupper(md5($shonustr));
        
        if($shonusign == $signature){
            if(!isset($_SERVER['HTTP_AUTHORIZATION'])) {
                $res['code'] = 4;
                $res['msg'] = 'Authorization header missing';
                $res['msgCode'] = 2;
                http_response_code(401);
                echo json_encode($res);
                exit;
            }

            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
            $author = $bearer[1];
            
            error_log("JWT Token: " . $author);
            
            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, 1);
            
            error_log("JWT Validation Result: " . json_encode($data_auth));
            
            if($data_auth['status'] === 'Success') {
                $sesquery = "SELECT akshinak FROM shonu_subjects WHERE akshinak = '$author'";
                $sesresult = $conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);
                
                if($sesnum == 1){
                    $typeId = $issueNumber[8].$issueNumber[9];
                    $shonuid = $data_auth['payload']['id'];
                    
                    error_log("Type ID: " . $typeId);
                    error_log("User ID from JWT: " . $shonuid);
                    error_log("Issue Number: " . $issueNumber);

                    // Check all tables in specific order
                    $tables = [
                        'bajikattuttate_kemuru_funf',    // Check 5min first
                        'bajikattuttate_kemuru_zehn',    // Check 10min second
                        'bajikattuttate_kemuru',         // Then 1min
                        'bajikattuttate_kemuru_drei'     // Then 3min
                    ];

                    $foundData = null;
                    $foundTable = '';

                    // Search for data in all tables
                    foreach($tables as $table) {
                        $checkQuery = "SELECT phalaphala, sesabida, ergebnis, zufallig 
                                     FROM $table 
                                     WHERE kalaparichaya = '$issueNumber'
                                     ORDER BY parichaya DESC LIMIT 1";
                        $checkResult = $conn->query($checkQuery);
                        error_log("Checking table $table for issue $issueNumber");
                        
                        if($checkResult && $checkResult->num_rows > 0) {
                            $foundTable = $table;
                            $foundData = $checkResult->fetch_assoc();
                            error_log("Found data in table: $table");
                            error_log("Found data: " . json_encode($foundData));
                            break;
                        }
                    }

                    if(!$foundTable || !$foundData) {
                        $res['code'] = 9;
                        $res['msg'] = 'No data found';
                        $res['msgCode'] = 8;
                        $res['debug'] = [
                            'user_id' => $shonuid,
                            'issue_number' => $issueNumber,
                            'searched_tables' => $tables
                        ];
                        http_response_code(404);
                        echo json_encode($res);
                        exit;
                    }

                    $data = [
                        'issueNumber' => $issueNumber,
                        'number' => $foundData['ergebnis'],
                        'winAmount' => $foundData['sesabida'],
                        'typeName' => $typeId,
                        'state' => ($foundData['phalaphala'] == 'perte') ? 0 : 1,
                        'premium' => $foundData['zufallig']
                    ];
                    
                    $res['data'] = $data;
                    $res['code'] = 0;
                    $res['msg'] = 'Succeed';
                    $res['msgCode'] = 0;
                    $res['serviceNowTime'] = $shnunc;
                    http_response_code(200);
                    echo json_encode($res);
                    exit;
                }
            }
            $res['code'] = 4;
            $res['msg'] = 'No operation permission';
            $res['msgCode'] = 2;
            http_response_code(401);
            echo json_encode($res);
            exit;
        }
        $res['code'] = 5;
        $res['msg'] = 'Wrong signature';
        $res['msgCode'] = 3;
        http_response_code(200);
        echo json_encode($res);
        exit;
    }
    $res['code'] = 7;
    $res['msg'] = 'Param is Invalid';
    $res['msgCode'] = 6;
    http_response_code(200);
    echo json_encode($res);
    exit;
}
http_response_code(405);
echo json_encode($res);
exit;
?>